/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                            *** TC Version ***   */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   TITLE       : DEMOVMP.C                                                */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demostrates how to perform voice out using the        */
/*       CT-VOICE.DRV driver. The voice out is using the Conventional       */
/*       memory method.                                                     */
/*                                                                          */
/*       The program checks BLASTER environment for the Card settings.      */
/*       It also performs test base on BLASTER environment settings to      */
/*       ensure they are tally with the hardware settings on the Card.      */
/*                                                                          */
/*       Note that the program included the module LOADDRV.C to load        */
/*       the loadable CT-VOICE.DRV into memory.                             */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <io.h>
#include  <dos.h>
#include  <bios.h>
#include  <stdio.h>
#include  <fcntl.h>
#include  <string.h>
#include  <stdlib.h>

#include  <sbc.h>
#include  <sbcvoice.h>

#define   FPSEG(fp) (*((unsigned far *)&(fp)+1))
#define   FPOFF(fp) (*((unsigned far *)&(fp)))

#include  "loaddrv.c"



/* Function Prototypes */
char far *LoadFile(char *szFilename) ;


main()
{
    extern  char far * near voice_drv;
    char    far *lpVoiceBuf ;


    /* Retrieve the BLASTER environment settings */
    if ( ! GetEnvSetting() )
    {
        if (sbc_check_card() & 4)
        {
            if (sbc_test_int())
            {
                if (sbc_test_dma() >= 0)
                {
                    if ((voice_drv = LoadDriver("CT-VOICE.DRV")) != 0)
                    {
                        if (!ctvm_init())
                        {
                            ctvm_speaker(0) ;

                            if ( (lpVoiceBuf = LoadFile("DEMO.VOC")) != 0 )
                            {
                                OutputVoice(lpVoiceBuf) ;
                                freemem(FPSEG(lpVoiceBuf)) ;
                            }

                            ctvm_terminate() ;
                        }
                    }
                }
                else
                    printf("Error on DMA channel.\n");
            }
            else
                printf("Error on interrupt.\n");
        }
        else
            printf("Sound Blaster Card not found or wrong I/O settings.\n") ;
    }
    else
        printf("BLASTER environment not set or incomplete or invalid.\n");
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   char far *LoadFile (char *szFilename)                                  */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Load file into memory.                                             */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szFileName :- File to be loaded.                                   */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Pointer to the loaded memory buffer if successfull, else returns   */
/*       NULL pointer.                                                      */
/*                                                                          */
/* ------------------------------------------------------------------------ */

char far *LoadFile (char *szFilename)
{
    char        far *lpFileBuf=0, far *lpTmpPtr ;
    int         Handle ;
    unsigned    wByteRead;
    long        lFileSize ;


    /* open file */
    if ((Handle=_open(szFilename,O_RDONLY)) != -1)
    {
        lFileSize = filelength(Handle) ;

        if (allocmem((unsigned)((lFileSize+15) >> 4),&wByteRead) == -1)
        {
            FPSEG(lpFileBuf) = wByteRead ;
            FPOFF(lpFileBuf) = 0 ;

            lpTmpPtr = lpFileBuf ;

            do
            {
                if (DosRead(Handle,lpTmpPtr,0x8000,&wByteRead) != 0)
                {
                    if ( !(FPOFF(lpTmpPtr) += wByteRead) )
                        FPSEG(lpTmpPtr) += 0x1000 ;
                }
                else
                {
                    printf("Load file error.\n");
                    wByteRead = 0 ;
                    lpFileBuf = 0 ;
                    freemem(FPSEG(lpFileBuf)) ;
                }

            } while (wByteRead == 0x8000) ;
        }
        else
            printf("Memory allocation error.\n");

        _close(Handle) ;
    }
    else
        printf("Open %s fails.\n",szFilename) ;


    return(lpFileBuf) ;
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   int OutputVoice (char far *lpBuf)                                      */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Output voice from a memory buffer. The user is allowed to control  */
/*       the voice output from the keyboard.                                */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       lpBuf :- Memory buffer to be output.                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Non-zero if successful, else returns 0                             */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma loop_opt (off)
OutputVoice (char far *lpBuf)
{
    unsigned    wKey ;
    int         done = 0;


    lpBuf += ((VOCHDR far *)lpBuf)->voice_offset ;

    /* turn on speaker */
    ctvm_speaker(1) ;

    if (ctvm_output(lpBuf) == NO_ERROR)
    {
        done = 1;

        /* loop until voice stop */
        while (ct_voice_status)
        {
            if (bioskey(1))
            {
                if ( (wKey=bioskey(0)) & 0xff )
                {
                    switch(toupper(wKey & 0xff))
                    {
                        case 0x1b:
                        case 'S' : ctvm_stop() ;
                            break;
                        case 'P' : ctvm_pause() ;
                            break;
                        case 'C' : ctvm_continue() ;
                            break;
                        case 'B' : ctvm_break_loop(1) ;
                            break;
                    }
                }
            }
        }
    }

    /* turn off speaker */
    ctvm_speaker(0) ;


    return (done);
}
#pragma loop_opt()



/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   DosRead (int Handle, char far *Buffer,                                 */
/*            unsigned wLen, unsigned *lpByteRead)                          */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       DOS read function using DOS interrupt 0x21 function 0x3F.          */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       Handle :- File handle to read.                                     */
/*       Buffer :- Buffer to write to.                                      */
/*       wLen   :- Number of byte to read.                                  */
/*       lpByteRead :- pointer to number of byte actually read.             */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Byte read if successful, else returns 0.                           */
/*                                                                          */
/* ------------------------------------------------------------------------ */

DosRead (int Handle, char far *Buffer, unsigned wLen, unsigned *wByteRead)
{
    union REGS regs;
    struct SREGS segregs;


    regs.h.ah = 0x3f ;
    regs.x.bx = Handle;
    regs.x.dx = FPOFF(Buffer);
    regs.x.cx = wLen;
    segregs.ds = FPSEG(Buffer);

    intdosx(&regs, &regs, &segregs);

    if(regs.x.cflag)    /* error */
        *wByteRead = 0;
    else
        *wByteRead = regs.x.ax ;


    return(*wByteRead);
}
